@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      getcfg.bat
REM
REM  Contents:  batch file which output the choice of XML configuration file is 
REM		to be used by the Configuration Server by outputting its name
REM		to the file "conf.choice".
REM
REM ----------------------------------------------------------------------------


REM ######################################################################
REM ###                                                                ###
REM ### This file is called by the Provisioning Server program         ###
REM ### in order to get a recommended configuration for the configured ###
REM ### device.                                                        ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ### The calling application passes environment variables to this   ###
REM ### batch script in order to allow some flexibility with the       ###
REM ### configuration process.                                         ###
REM ### Eventually, this information is obtained by the caller again.  ###
REM ###                                                                ###
REM ######################################################################

IF "%PROVISIONING_UUID%"=="" goto nouuid

set UUID_SPECIFIC_FILE=%PROVISIONING_UUID%.conf.xml
set DEFAULT_FILE=default.conf.xml
set CHOICE_FILE=conf.choice
set LOG_FILE=getcfg.log

if exist %LOG_FILE% del /q %LOG_FILE%
echo getcfg.bat called with the following parameters: >> %LOG_FILE%
echo UUID=%PROVISIONING_UUID% >> %LOG_FILE%
if not "%PROVISIONING_VERSION%"=="" echo VERSION=%PROVISIONING_VERSION%	>> %LOG_FILE%
if not "%PROVISIONING_ORIGINATING_IP%"=="" echo ORIGINATING_IP=%PROVISIONING_ORIGINATING_IP% >> %LOG_FILE%

echo Looking for file "%UUID_SPECIFIC_FILE%": >> %LOG_FILE%
if exist %UUID_SPECIFIC_FILE% (
	echo Found "%UUID_SPECIFIC_FILE%" >> %LOG_FILE%
	set CONFIG_FILE=%UUID_SPECIFIC_FILE%
) else (
	echo File "%UUID_SPECIFIC_FILE%" not found, using default >> %LOG_FILE%
	set CONFIG_FILE=%DEFAULT_FILE%
)
echo Configure Intel (R) AMT with settings in "%CONFIG_FILE%" >> %LOG_FILE%
echo %CONFIG_FILE% > %CHOICE_FILE%

goto end

:nouuid
echo Error, could not run batch:													>> %LOG_FILE%
echo This batch cannot continue because the PROVISIONING_UUID variable is not set >> %LOG_FILE%
echo Note: The Provisioning software sets this variable before calling this batch >> %LOG_FILE%
REM echo .												
pause 
goto end

:end
